IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[V_TABELAS_VALIDAR_UUID]'))
DROP VIEW [dbo].[V_TABELAS_VALIDAR_UUID]
GO
--SELECT * FROM V_TABELAS_VALIDAR_UUID ORDER BY TIPO
CREATE VIEW V_TABELAS_VALIDAR_UUID 
WITH ENCRYPTION
AS
SELECT
	'PRODUTO' TIPO,
	'EST_PROD' AS TABELA,
	COUNT(*) AS QTDE_REGISTROS
FROM
	EST_PROD
WHERE
	UUID IS NULL
UNION ALL
SELECT
	'NF ENTRADA' TIPO,
	'EST_NF_ENT' AS TABELA,
	COUNT(*)
FROM
	EST_NF_ENT
WHERE
	UUID IS NULL
	AND DT_ENT>=GETDATE()-396
UNION ALL
SELECT
	'NF SAIDA' TIPO,
	'EST_NF_SAI' AS TABELA,
	COUNT(*)
FROM
	EST_NF_SAI
WHERE
	UUID IS NULL
	AND DT_EMI_NF>=GETDATE()-396
UNION ALL
SELECT
	'PEDIDO COMPRA' TIPO,
	'EST_PED_CP' AS TABELA,
	COUNT(*)
FROM
	EST_PED_CP
WHERE
	UUID IS NULL
	AND DT_EMI>=GETDATE()-396
UNION ALL
SELECT
	'PRE-FATURA' TIPO,
	'EST_PED_VD' AS TABELA,
	COUNT(*)
FROM
	EST_PED_VD
WHERE
	UUID IS NULL
	AND DT_EMI_PED>=GETDATE()-396	
UNION ALL
SELECT
	'FORNECEDOR' TIPO,
	'PG_FORN' AS TABELA,
	COUNT(*)
FROM
	PG_FORN
WHERE
	UUID IS NULL
UNION ALL
SELECT
	'CONTAS A PAGAR BAIXA' TIPO,
	'PG_DEB' AS TABELA,
	COUNT(*)
FROM
	PG_DEB
WHERE
	UUID IS NULL
UNION ALL
SELECT
	'CONTAS A PAGAR' TIPO,
	'PG_CRED' AS TABELA,
	COUNT(*)
FROM
	PG_CRED
WHERE
	UUID IS NULL
UNION ALL
SELECT
	'CLIENTES' TIPO,
	'RC_CLI' AS TABELA,
	COUNT(*)
FROM
	RC_CLI
WHERE
	UUID IS NULL
UNION ALL
SELECT
	'DANFE IMPORTADO' TIPO,
	'EST_NF_ENT_DANFE_PROVISORIO' AS TABELA,
	COUNT(*)
FROM
	EST_NF_ENT_DANFE_PROVISORIO
WHERE
	UUID IS NULL
UNION ALL
SELECT
	'FILIAIS' TIPO,
	'PRC_FILIAL' AS TABELA,
	COUNT(*)
FROM
	PRC_FILIAL
WHERE
	UUID IS NULL
UNION ALL
SELECT
	'AJUSTE ESTOQUE' TIPO,
	'EST_PROD_IMP' AS TABELA,
	COUNT(*)
FROM
	EST_PROD_IMP
WHERE
	UUID IS NULL
UNION ALL
SELECT
	'RATEIO DE DESPESAS' TIPO,
	'PG_DESP_RAT' AS TABELA,
	COUNT(*)
FROM
	PG_DESP_RAT
WHERE
	UUID IS NULL	
UNION ALL
SELECT
	'DESPAS RECEITAS CADASTRO' TIPO,
	'GLB_DESP_REC' AS TABELA,
	COUNT(*)
FROM
	GLB_DESP_REC
WHERE
	UUID IS NULL		
UNION ALL
SELECT
	'NUMERO CONTROLE DUPLICATA CONTA A PAGAR' TIPO,
	'PG_CRED_DUP_NR_CTR' AS TABELA,
	COUNT(*)
FROM
	PG_CRED_DUP_NR_CTR
WHERE
	UUID IS NULL
UNION ALL
SELECT
	'NUMERO CONTROLE DUPLICATA CONTA A RECEBER' TIPO,
	'RC_DEB_DUP_NR_CTR' AS TABELA,
	COUNT(*)
FROM
	RC_DEB_DUP_NR_CTR
WHERE
	UUID IS NULL